<?php
	session_start();
	date_default_timezone_set('America/Mexico_City');

	define ('DOMAIN', $_SERVER['SERVER_NAME']);
	define ('SESSION_PREFIX', $table_prefix);
	define ('SESSION_AUTH_TOKEN', SESSION_PREFIX.'_authToken');
	define ('REPLACE_URL', 'http://fb4ece06.ngrok.io');

	$EXCERPT_LENGTH = 55;
	$EXCERPT_MORE = ' [...]';
	
	$BASE_URL = '';
	$TEMPLATE_URL = '';
	$IS_THE_HOME = false;
	$IS_MOBILE = false;
	
	add_action('after_setup_theme', 'custom_after_setup_theme');
	add_filter('widget_text', 'do_shortcode');
	
	function custom_after_setup_theme(){
		remove_admin_bar();
		add_theme_support( 'post-thumbnails' ); 
	}
	
	require(get_template_path().'/php/_token.php');
	require(get_template_path().'/php/_widgets.php');
	
	function pre($v = array(), $c = '#000'){
		echo "<pre style='color: $c; font-family: Consolas, Arial, Helvetica, sans-serif;'>";
		print_r($v);
		echo '</pre>';
	}

	function _p($s = ''){
		echo $s;
	}
	
	function load_view($view = '', $params = array(), $cond = false){
		if(!is_array($params)){
			$params = array();
		}
		extract($params);
		$is_php = false;
		if(strlen($view) > 4){
			if(substr($view, -4, 4) == '.php'){
				$is_php = true;
			}
		} 
		if(!$is_php){
			$view .= '.php';
		}
		if($view != ''){
			if(!$cond){
				include($view);
			} else {
				ob_start();
				include($view);
				$view = ob_get_clean();
				return $view;
			}
		}
	}
	
	function file_get_contents_https($url = ''){
		$ch = curl_init(); 
		curl_setopt($ch, CURLOPT_URL, $url); 
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
		$output = curl_exec($ch); 
		curl_close($ch); 
		return $output;
	}
	
	function day_name($n = 1){
		$d = '';
		if($n == 1){
			$d = 'Lunes';
		}
		if($n == 2){
			$d = 'Martes';
		}
		if($n == 3){
			$d = 'Miércoles';
		}
		if($n == 4){
			$d = 'Jueves';
		}
		if($n == 5){
			$d = 'Viernes';
		}
		if($n == 6){
			$d = 'Sábado';
		}
		if($n == 7){
			$d = 'Domingo';
		}
		return $d;
	}
	
	function month_name($m = 1){
		$d = '';
		if($m == 1){
			$d = 'Enero';
		}
		if($m == 2){
			$d = 'Febrero';
		}
		if($m == 3){
			$d = 'Marzo';
		}
		if($m == 4){
			$d = 'Abril';
		}
		if($m == 5){
			$d = 'Mayo';
		}
		if($m == 6){
			$d = 'Junio';
		}
		if($m == 7){
			$d = 'Julio';
		}
		if($m == 8){
			$d = 'Agosto';
		}
		if($m == 9){
			$d = 'Septiembre';
		}
		if($m == 10){
			$d = 'Octubre';
		}
		if($m == 11){
			$d = 'Noviembre';
		}
		if($m == 12){
			$d = 'Diciembre';
		}
		return $d;
	}
	
	function random_string($type = 'alnum', $len = 8){
		switch($type){
			case 'basic'	: return mt_rand();
				break;
			case 'alnum'	:
			case 'numeric'	:
			case 'nozero'	:
			case 'alpha'	:

					switch ($type){
						case 'alpha'	:	$pool = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
							break;
						case 'alnum'	:	$pool = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
							break;
						case 'numeric'	:	$pool = '0123456789';
							break;
						case 'nozero'	:	$pool = '123456789';
							break;
					}

					$str = '';
					for ($i=0; $i < $len; $i++){
						$str .= substr($pool, mt_rand(0, strlen($pool) -1), 1);
					}
					return $str;
				break;
			case 'unique'	:
			case 'md5'		:

						return md5(uniqid(mt_rand()));
				break;
			case 'encrypt'	:
			case 'sha1'	:

						return do_hash(uniqid(mt_rand(), true), 'sha1');
				break;
		}
	}
	
	function do_hash($str, $type = 'sha1'){
		if ($type == 'sha1'){
			return sha1($str);
		} else {
			return md5($str);
		}
	}
	
	function format_number($n = '', $d = 2){
		if ($n == ''){
			return '0.00';
		}
		$n = trim(preg_replace('/([^0-9\.])/i', '', $n));

		return number_format($n, $d, '.', ',');
	}
	
	function get_rv(){
		$d = '1.2';
		if(is_localhost()){
			$d = time();
		}
		return $d;
	}
	
	function _rv(){
		echo get_rv();
	}
	
	function redirect($url = false){
		if($url){
			wp_redirect( $url );
			exit;
		}
	}	
	
	function get_the_current_url(){
		$d = site_url( $_SERVER['REQUEST_URI'] );
		if(is_localhost()){
			$d = str_replace(DOMAIN.'/'.DOMAIN, DOMAIN, $d);
		}
		if(is_demo()){
			$d = str_replace(DOMAIN.'/'.DOMAIN, DOMAIN, $d);
		}
		return $d;
	}
	
	function the_current_url(){
		echo get_the_current_url();
	}
	
	function get_the_site_title(){
		$title = get_site_name();
		
		$site_description = get_bloginfo( 'description', 'display' );
		if ( $site_description && ( is_the_home() ) ) {
			$title .= " | $site_description";
			
		}
		echo $title; 
		wp_title( '|', true, 'left' );
	}
	
	function the_site_title(){
		echo get_the_site_title();
	}
	
	function is_the_home(){
		global $IS_THE_HOME;
		$d = $IS_THE_HOME;
		return $d;
	}
	
	function get_site_name(){
		$d = get_bloginfo('name');
		return $d;
	}
	
	function site_name(){
		echo get_site_name();
	}
	
	function get_base_url(){
		global $BASE_URL;
		$d = $BASE_URL;
		return $d;
	}
	
	function base_url(){
		echo get_base_url();
	}
	
	function get_template_url(){
		global $TEMPLATE_URL;
		$d = $TEMPLATE_URL;
		return $d;
	}
	
	function template_url(){
		echo get_template_url();
	}
	
	function get_template_path(){
		$d = TEMPLATEPATH;
		return $d;
	}
	
	function template_path(){
		echo get_template_path();
	}
	
	function get_stylesheet_url(){
		$d = get_bloginfo('stylesheet_url');
		return $d;
	}
	
	function stylesheet_url(){
		echo get_stylesheet_url();
	}
	
	function is_mobile(){
		global $IS_MOBILE;
		$d = $IS_MOBILE;
		return $d;
	}
	
	function is_localhost(){
		$d = false;
		$pos = strpos(get_base_url(), '127.0.0.1');
		if ($pos !== false) {
			$d = true;
		}
		return $d;
	}
	
	function is_demo(){
		$d = false;
		$pos = strpos(get_base_url(), 'cubitosweb');
		if ($pos !== false) {
			$d = true;
		}
		return $d;
	}
	
	function get_nav_menu_items($menu_name = ''){
		$locations = get_nav_menu_locations();
		$menu_items = array();
		if ( ( $locations ) && isset( $locations[ $menu_name ] ) ) {
			$menu = wp_get_nav_menu_object( $locations[ $menu_name ] );
			$menu_items = wp_get_nav_menu_items($menu->term_id);
		}
		$d = $menu_items;
		return $d;
	}
	
	add_filter('nav_menu_css_class' , 'custom_nav_menu_css_class' ,10 ,2);
	
	function custom_nav_menu_css_class($classes, $item){
		 if(in_array('current-menu-item', $classes)){
				 $classes[] = 'active ';
		 }
		 return $classes;
	}
		
	function get_custom_trim_excerpt( $text = '', $length = 40, $more = ' [...]' ){
		$trimmed_content = wp_trim_words( $text, $length, $more );
		$d = wpautop($trimmed_content);
		return $d;
	}
	
	function custom_trim_excerpt( $text = '', $length = 40, $more = ' [...]' ){
		echo get_custom_trim_excerpt( $text, $length, $more );
	}
	
	function custom_excerpt_length( $length ) {
		global $EXCERPT_LENGTH;
		return $EXCERPT_LENGTH;
	}

	function set_custom_excerpt_length( $length ) {
		global $EXCERPT_LENGTH;
		$EXCERPT_LENGTH = $length;
	}
	
	function custom_excerpt_more( $more ) {
		global $EXCERPT_MORE;
		return $EXCERPT_MORE;
	}

	function set_custom_excerpt_more( $more ) {
		global $EXCERPT_MORE;
		$EXCERPT_MORE = $more;
	}
	
	add_filter('excerpt_more', 'custom_excerpt_more');
	add_filter('excerpt_length', 'custom_excerpt_length', 999);
	
	function pagination($paged = 1, $max_num_pages = 1){
		
		$big = 999999999; // need an unlikely integer
		
		$pagination = paginate_links( array(
			'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
			//'format' => '?paged=%#%',
			'current' => max( 1, $paged ),
			'total' => $max_num_pages,
			'type' => 'array'
		));
		
		$html = '';
		
		if($pagination){
			$html .= '
					<nav class="nav-pagination">
						<ul class="pagination">
					';
			foreach($pagination as $page){
				$pos = strpos($page, 'current');
				if($pos !== false) {
					$html .= '<li class="disabled active">'.$page.'</li>';
				} else {
					$html .= '<li>'.$page.'</li>';
				}
			}
			$html .= '
						</ul>
					</nav>
				';
		}
		echo $html;
	}

	function get_theme_image($id = 0){
		$d = array(
			'ID' => 0,
			'title' => '',
			'caption' => '',
			'alt' => '',
			'description' => '',
			'url' => '',
			'width' => 0,
			'height' => 0
		);
		if($id){
			$image = get_post($id);
			if($image){
				$d['ID'] = $image->ID;
				$d['title'] = $image->post_title;
				$d['caption'] = $image->post_excerpt;
				$d['alt'] = $image->_wp_attachment_image_alt;
				$d['description'] = $image->post_content;
				
				$imageArray = wp_get_attachment_image_src($id, 'full');
				$url = $imageArray[0];
				$w = $imageArray[1];
				$h = $imageArray[2];
				$d['url'] = $url;
				$d['width'] = $w;
				$d['height'] = $h;
			}
		}
		if(!$d['ID']){
			$url = get_template_url().'/images/no-image.jpg'; 
			$d['url'] = $url;
			$d['width'] = 270;
			$d['height'] = 270;
		}
		$d = (object)$d;
		return $d;
	}

	function get_theme_file($id = 0){
		$d = array(
			'ID' => 0,
			'title' => '',
			'caption' => '',
			'description' => '',
			'url' => '',
			'icon' => ''
		);
		if($id){
			$image = get_post($id);
			if($image){
				$icon = wp_mime_type_icon($image->post_mime_type);
				$d['ID'] = $image->ID;
				$d['title'] = $image->post_title;
				$d['caption'] = $image->post_excerpt;
				$d['description'] = $image->post_content;
				$url = wp_get_attachment_url($id);
				$d['url'] = $url;
				$d['icon'] = $icon;
			}
		}
		$d = (object)$d;
		return $d;
	}
	
	function get_thumbnail($post_id = 0, $size = 'full'){
		$d = array(
			'ID' => 0,
			'title' => '',
			'caption' => '',
			'alt' => '',
			'description' => '',
			'url' => '',
			'width' => 0,
			'height' => 0
		);
		if(!$post_id){
			$post_id = get_the_ID();
		}
		if(is_object($post_id)){
			$post_id = $post_id->ID;
		}
		if ( has_post_thumbnail($post_id) ) {

			$thumbnail_id = get_post_thumbnail_id($post_id);
			$thumbnail = get_post($thumbnail_id);
			$alt = $thumbnail->_wp_attachment_image_alt;
			
			$d['ID'] = $thumbnail->ID;
			$d['title'] = $thumbnail->post_title;
			$d['caption'] = $thumbnail->post_excerpt;
			$d['alt'] = $alt;
			$d['description'] = $thumbnail->post_content;
			
			$imageArray = wp_get_attachment_image_src($thumbnail_id, $size);
			$url = $imageArray[0];
			$w = $imageArray[1];
			$h = $imageArray[2];
			$d['url'] = $url;
			$d['width'] = $w;
			$d['height'] = $h;
			
		} else {
			$url = get_template_url().'/images/no-image.jpg'; 
			$d['url'] = $url;
			$d['width'] = 270;
			$d['height'] = 270;
		}
		$d = (object)$d;
		return $d;
	}

	function get_term_thumbnail($term_id = 0){
		$d = array(
			'ID' => 0,
			'title' => '',
			'caption' => '',
			'alt' => '',
			'description' => '',
			'url' => '',
			'width' => 0,
			'height' => 0
		);
		$thumbnail_id = 0;
		if(is_object($term_id)){
			$term_id = $term_id->term_id;
		}
		if($term_id){
			$thumbnail_id = get_term_meta($term_id, '_thumbnail', true);
		}
		if($thumbnail_id){
			$thumbnail = get_post($thumbnail_id);
			$alt = $thumbnail->_wp_attachment_image_alt;
			$d['ID'] = $thumbnail->ID;
			$d['title'] = $thumbnail->post_title;
			$d['caption'] = $thumbnail->post_excerpt;
			$d['alt'] = $alt;
			$d['description'] = $thumbnail->post_content;
			
			$imageArray = wp_get_attachment_image_src($thumbnail_id, 'full');
			$url = $imageArray[0];
			$w = $imageArray[1];
			$h = $imageArray[2];
			$d['url'] = $url;
			$d['width'] = $w;
			$d['height'] = $h;
			
		} else {
			$url = get_template_url().'/images/no-image.jpg'; 
			$d['url'] = $url;
			$d['width'] = 270;
			$d['height'] = 270;				
		}

		$d = (object)$d;
		return $d;
	}
	
	function get_term_depth($term_id = 0, $taxonomy = ''){
		$d = 0;
		if(is_object($term_id)){
			$term_id = $term_id->term_id;
		}
		$ancestors = get_ancestors($term_id, $taxonomy);
		$d = count($ancestors);
		return $d;
	}
	
	function get_the_timthumb($url = '', $w = 100, $h = 100, $params = '', $q = 100){
		// color f=5,R,G,B,A Ej: f=5,131,204,31,1
		$template_url = get_template_url();
		if($params){
			$params = '&amp;'.$params;
		}
		$params = $params.'&amp;q='.$q;
		$d = $template_url.'/php/timthumb.php?src='.$url."&amp;w=$w&amp;h=$h&amp;q=80".$params;
		return $d;
	}
	
	function the_timthumb($url = '', $w = 100, $h = 100, $params = '', $q = 100){
		$d = get_the_timthumb($url, $w, $h, $params, $q);
		echo $d;
	}
	
	function is_request_method_get(){
		$d = false;
		if ($_SERVER['REQUEST_METHOD'] == 'GET'){
			$d = true;
		}
		return $d;
	}
	
	function is_request_method_post(){
		$d = false;
		if ($_SERVER['REQUEST_METHOD'] == 'POST'){
			$d = true;
		}
		return $d;
	}
	
	function delete_post($post_id = 0){
		if(is_object($post_id)){
			$post_id = $post_id->ID;
		}
		wp_delete_post( $post_id, true );
	}
	
	function get_filter_content($content = ''){
		$d = apply_filters('the_content', $content);
		return $d;
	}
	
	function the_filter_content($content = ''){
		echo get_filter_content($content);
	}
	
	add_action( 'admin_bar_menu', 'custom_admin_bar_menu', 999);

	function custom_admin_bar_menu( $wp_admin_bar ) {
		$wp_admin_bar->remove_node( 'wp-logo' );
	}
	
	function remove_admin_bar() {
		$is_the_user_admin = is_the_user_admin();
		if(!$is_the_user_admin){
			show_admin_bar(false);
		}
	}
	
	add_action('wp_head', 'custom_wp_head');

	function custom_wp_head() {
		$is_the_user_admin = is_the_user_admin();
		if($is_the_user_admin){
			
			// echo '
			//	<style type="text/css">
			//		/* margin-top: 32px; */
			//		@media (min-width: 992px) {
			//		}
			//		/* margin-top: 32px; */
			//		@media (min-width: 783px) {
			//		}
			//		/* margin-top: 46px; */
			//		@media (max-width: 782px) {
			//		}
			//	</style>
			//';
			
		}
	}

	add_action( 'current_screen', 'custom_current_screen' );

	function custom_current_screen() {
		$current_screen = get_current_screen();
		if(is_the_user_subscriber() && is_admin()){
			if($current_screen->id != 'async-upload'){
				redirect(get_base_url());
			}
		}
		if($current_screen->base != 'post'){
			wp_enqueue_media();
		}
	}
	
	function is_the_user($role = '', $user_id = false){
		$d = false;
		$current_user = false;
		if(is_object($user_id)){
			$current_user = $user_id;
		} elseif ($user_id) {
			$current_user = get_userdata( $user_id );
		} else {
			$current_user = wp_get_current_user();
		}
		if($current_user){
			if($current_user->roles){
				if(in_array($role, $current_user->roles)){
					$d = true;
				}
			}
		}
		return $d;
	}	
	
	function is_the_user_admin($user_id = false){
		$d = is_the_user('administrator', $user_id);
		return $d;
	}
	
	function is_the_user_subscriber($user_id = false){
		$d = is_the_user('subscriber', $user_id);
		return $d;
	}
	
	function send_email($to = '', $subject = '', $message = '', $cc = '', $bcc = ''){
		$d = false;
		$name = get_site_name();
		$headers[] = 'From: '.$name.' <no_reply@'.DOMAIN.'>';
		if($cc){
			if(is_array($cc)){
				foreach($cc as $_cc){
					$headers[] = 'Cc: '.$_cc;
				}
			} else {
				$headers[] = 'Cc: '.$cc;
			}
		}
		if($bcc){
			if(is_array($bcc)){
				foreach($bcc as $_bcc){
					$headers[] = 'Bcc: '.$_bcc;
				}
			} else {
				$headers[] = 'Bcc: '.$bcc;
			}
		}

		add_filter( 'wp_mail_content_type', 'set_html_content_type' );

		$d = wp_mail( $to, $subject, $message, $headers );
		
		remove_filter( 'wp_mail_content_type', 'set_html_content_type' );
		
		return $d;
	}
	
	function set_html_content_type() {
		return 'text/html';
	}
	
	function term_add_custom_fields(){
		echo '
			<div class="form-field">
				<label for="term-image">Imagen</label>
				<button class="button add-custom-theme-image" type="button" data-img="#term-img" data-input="#term-image">Agregar / Editar imagen</button>
				<img src="" class="custom-theme-img" id="term-img" />
				<a href="#" data-img="#term-img" data-input="#term-image" class="remove-custom-theme-image">Quitar imagen</a>
				<input type="hidden" value="" id="term-image" name="term_image">
			</div>
		';
	}
	
	function term_edit_custom_fields($term){
		$term_id = $term->term_id;
		$thumbnail1 = get_term_thumbnail($term_id);
		$class1 = '';
		if($thumbnail1->ID){
			$class1 = ' active';
		}

		echo '
			<tr class="form-field">
				<th scope="row">
					<label for="term-image">Imagen</label>
				</th>
				<td>					
					<button class="button add-custom-theme-image" type="button" data-img="#term-img" data-input="#term-image">Agregar / Editar imagen</button>
					<img src="'.$thumbnail1->url.'" class="custom-theme-img'.$class1.'" id="term-img" />
					<a href="#" data-img="#term-img" data-input="#term-image" class="remove-custom-theme-image">Quitar imagen</a>
					<input type="hidden" value="'.$thumbnail1->ID.'" id="term-image" name="term_image">
				</td>
			</tr>
		';
	}
	
	function save_term_custom_fields($term_id){
		$term_image = '';
		extract($_POST);
		update_term_meta($term_id, '_thumbnail', $term_image);
	}
	
	add_action('wp_ajax_nopriv_username_exists', 'ajax_username_exists');
	add_action('wp_ajax_username_exists', 'ajax_username_exists');
	
	function ajax_username_exists(){
		$d = 'true';
		if (is_request_method_post()){
			$username = '';
			extract($_POST);
			if ( username_exists( $username ) ){
				$d = 'false';
			}
		}
		echo $d;
		exit;
	}
	
	add_action('wp_ajax_nopriv_email_exists', 'ajax_email_exists');
	add_action('wp_ajax_email_exists', 'ajax_email_exists');
	
	function ajax_email_exists(){
		$d = 'true';
		if (is_request_method_post()){
			$email = '';
			extract($_POST);
			if ( email_exists( $email ) ){
				$d = 'false';
			}
		}
		echo $d;
		exit;
	}
	
	function get_ip(){
		if (!empty($_SERVER['HTTP_CLIENT_IP'])){   //check ip from share internet
			$ip = $_SERVER['HTTP_CLIENT_IP'];
		} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){   //to check ip is pass from proxy
			$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
		} else{
			$ip = $_SERVER['REMOTE_ADDR'];
		}
		return $ip;
	}
	
	function array_count_value($value = '', $array = array()){
		$d = 0;
		foreach($array as $k => $v){
			if($value == $v){
				$d++;
			}
		}
		return $d;
	}
	
	function get_sidebar_widgets($name = ''){
		$d = array();
		if($name){
			$sidebars = wp_get_sidebars_widgets();
			if(array_key_exists($name, $sidebars)){
				$d = $sidebars[$name];
			}
		}
		return $d;
	}
	
	function get_total_widgets($name = ''){
		$d = 0;
		if($name){
			$widgets = get_sidebar_widgets($name);
			$d = count($widgets);
		}
		return $d;
	}
	
	function metabox_posts_gallery_callback( $post ) {
		$gallery = get_the_gallery($post->ID);
		$html = '';
		foreach($gallery as $image){
			$thumnmail = get_the_timthumb($image->url, 100, 100);
			$html .= '
				<li>
					<a href="#" class="remove"><span class="dashicons dashicons-dismiss"></span></a>
					<img src="'.$thumnmail.'" alt="" />
					<input type="hidden" value="'.$image->ID.'" name="gallery[]">
				</li>
			';
		}
		$html = '
			<button class="button" id="add-image-gallery" type="button">Agregar imagen</button>
			<div class="gallery" id="gallery">
				<p>Arrastra para ordenar.</p>
				<ul id="gallery-sortable">
					'.$html.'
				</ul>
				<div class="clearfix"></div>
			</div>
		';
		echo $html;
	}
	
	function save_metabox_posts_gallery($post_id){
		if (is_request_method_post()){
			$posts = array('post');
			if (!in_array($_POST['post_type'], $posts)) {
				return $post_id;
			}
			$gallery = array();
			extract($_POST);
			if($action == 'editpost'){ //inline-save
				$gallery = json_encode($gallery);
				update_post_meta($post_id, 'gallery', $gallery);
			}
		}
	}
	
	add_action( 'save_post', 'save_metabox_posts_gallery' );
	
	function get_the_gallery($post_id = 0){
		$d = array();
		if(!$post_id){
			$post_id = get_the_ID();
		}
		if(is_object($post_id)) {
			$post_id = $post_id->ID;
		}
		if($post_id){
			$gallery = get_post_meta($post_id, 'gallery', true);
			if($gallery){
				$gallery = json_decode($gallery);
				if($gallery){
					foreach($gallery as $id){
						$image = get_theme_image($id);
						$d[] = $image;
					}
				}
			}
		}
		return $d;
	}

    function get_the_css(){
        $template_path = get_template_path();
        $template_url = get_template_url();
        $path = '/build/';
        $files = scandir($template_path.$path, 1);
        $file = 'app.css';
        if($files){
            $file = $files[1];
        }
        return $template_url.$path.$file;
    }

	function get_the_js(){
        $template_path = get_template_path();
        $template_url = get_template_url();
        $path = '/build/';
        $files = scandir($template_path.$path, 1);
        $file = 'app.js';
        if($files){
            $file = $files[0];
        }
	    return $template_url.$path.$file;
    }

    function the_css(){
        echo get_the_css();
    }

    function the_js(){
        echo get_the_js();
    }
	
	/******** - - - - - - - - ********/

	function custom_admin_scripts() {
		$template_url = get_template_url();
		
		wp_enqueue_style('custom-jquery-ui', $template_url.'/assets/css/jquery-ui.min.css');
		wp_enqueue_style('custom-fancybox', $template_url.'/assets/css/jquery.fancybox.css');
		wp_enqueue_style('custom-admin', $template_url.'/assets/css/admin.css', '', time());
		
		wp_enqueue_script('jquery-ui-datepicker');
		wp_enqueue_script('custom-datepicker', $template_url.'/assets/js/datepicker-es.js', '', '', true);
		wp_enqueue_script('custom-fancybox', $template_url.'/assets/js/jquery.fancybox.js', '', '', true);
		wp_enqueue_script('custom-fancybox-media', $template_url.'/assets/js/jquery.fancybox-media.js', '', '', true);
		wp_enqueue_script('custom-admin', $template_url.'/assets/js/admin.js', '', time(), true);
	}
	
	add_action('admin_head', 'custom_admin_scripts');
	add_action('login_enqueue_scripts', 'custom_admin_scripts');

	register_nav_menus(
		array(
			'theme_main_menu' => 'Menú Principal',
			'theme_login_paquetes_menu' => 'Menú Login Paquetes'
		)
	);
	
	add_action('wp_ajax_nopriv_check_login', 'ajax_check_login');
	add_action('wp_ajax_check_login', 'ajax_check_login');
	
	function ajax_check_login(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'user' => array(
				'ID' => 0,
				'name' => '',
				'image' => ''
			)
		);
		if (is_request_method_post()){
			$username = '';
			$password = '';
			extract($_POST);
			$user = get_user_by( 'login', $username );
			if($user && wp_check_password( $password, $user->data->user_pass, $user->ID)){
				if($registration_id){
					$registration_ids = get_user_meta($user->ID, 'registration_id');
					$is_id = false;
					foreach($registration_ids as $r_id){
						$rid = json_decode($r_id);
						if($rid){
							if($rid->id == $registration_id){
								$is_id = true;
							}
						}
					}
					if(!$is_id){
						$json = json_encode(array('platform' => $platform, 'id' => $registration_id));
						add_user_meta($user->ID, 'registration_id', $json);
					}
				}
				$thumbnail = get_theme_image($user->user_image);
				$d['code'] = 1;
				$d['user']['ID'] = $user->ID;
				$d['user']['name'] = $user->first_name.' '.$user->last_name;
				$d['user']['image'] = $thumbnail->url;
			}
		}
		echo json_encode($d);
		exit;
	}
	
	add_action('wp_ajax_nopriv_profile', 'ajax_profile');
	add_action('wp_ajax_profile', 'ajax_profile');
	
	function ajax_profile(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'user' => array(
				'ID' => 0,
				'name' => '',
				'image' => '',
				'email' => '',
				'telefono' => '',
				'direccion' => '',
				'nickname' => '',
				'ultima_menstruacion' => ''
			),
			'child' => array(
				'nombre_padre' => '',
				'sexo' => '',
				'peso' => '',
				'talla' => '',
				'diayhora' => '',
			)
		);
		if (is_request_method_post()){
			$user_id = 0;
			extract($_POST);
			$user = get_user_by( 'ID', $user_id );
			if($user){
				$thumbnail = get_theme_image($user->user_image);
				$dia = $user->dia;
				$hora = $user->hora;
				$minuto = $user->minuto;
				$ultima_menstruacion = $user->ultima_menstruacion;
				if(!$hora){
					$hora = 0;
				}
				if(!$minuto){
					$minuto = 0;
				}
				if($hora < 10){
					$hora = '0'.$hora;
				}
				if($minuto < 10){
					$minuto = '0'.$minuto;
				}
				if(!$ultima_menstruacion){
					$ultima_menstruacion = time();
				}
				if(!$dia){
					$dia = time();
				}
				$d['code'] = 1;
				$d['user']['ID'] = $user->ID;
				$d['user']['name'] = $user->first_name.' '.$user->last_name;
				$d['user']['image'] = $thumbnail->url;
				$d['user']['email'] = $user->user_email;
				$d['user']['telefono'] = $user->telefono;
				$d['user']['direccion'] = $user->direccion;
				$d['user']['nickname'] = $user->nickname;
				$d['user']['menstruacion'] = date('Y-m-d', $ultima_menstruacion);
				$d['child']['padre'] = $user->padre;
				$d['child']['sexo'] = $user->sexo;
				$d['child']['peso'] = $user->peso;
				$d['child']['talla'] = $user->talla;
				$d['child']['diayhora'] = date('Y-m-d', $dia).'T'.$hora.':'.$minuto.':00';
			}
		}
		echo json_encode($d);
		exit;
	}
	
	add_action('wp_ajax_nopriv_update_profile', 'ajax_update_profile');
	add_action('wp_ajax_update_profile', 'ajax_update_profile');
	
	function ajax_update_profile(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0
		);
		if (is_request_method_post()){
			$user_id = 0;
			extract($_POST);
			$user = get_user_by( 'ID', $user_id );
			if($user){
				$user_id = wp_update_user(array('ID' => $user->ID, 'nickname' => $nickname));
				if (!is_wp_error( $user_id)) {
					$ultima_menstruacion = strtotime($ultima_menstruacion);
					$mestruacion = date('d/m/Y', $ultima_menstruacion);
					$dia = strtotime($diayhora);
					$hora = (int)date('H', $dia);
					$minuto = (int)date('i', $dia);
					$diayhora = date('d/m/Y', $dia);
					update_user_meta( $user_id, 'ultima_menstruacion', $ultima_menstruacion);
					update_user_meta( $user_id, 'menstruacion', $menstruacion);
					update_user_meta( $user_id, 'padre', $padre);
					update_user_meta( $user_id, 'sexo', $sexo);
					update_user_meta( $user_id, 'peso', $peso);
					update_user_meta( $user_id, 'talla', $talla);
					update_user_meta( $user_id, 'dia', $dia);
					update_user_meta( $user_id, 'hora', $hora);
					update_user_meta( $user_id, 'minuto', $minuto);
					update_user_meta( $user_id, 'diayhora', $diayhora);
					if($filename){
						$upload_dir = wp_upload_dir();
						$path = $upload_dir['basedir'].'/app';
						$url = $upload_dir['baseurl'].'/app';
						$file = $url.'/'.$filename;
						$filetype = wp_check_filetype( basename( $file ), null );	
						$attachment = array(
							'guid' => $file,
							'post_mime_type' => $filetype['type'],
							'post_title' => preg_replace( '/\.[^.]+$/', '', basename( $file ) ),
							'post_content' => '',
							'post_status' => 'inherit',
							'post_author' => $user_id
						);
						$attach_id = wp_insert_attachment( $attachment, $file, 0 );
						if($attach_id){
							update_user_meta( $user_id, 'user_image', $attach_id);
							require_once( ABSPATH . 'wp-admin/includes/image.php' );
							$attach_data = wp_generate_attachment_metadata( $attach_id, $path.'/'.$filename );
							wp_update_attachment_metadata( $attach_id, $attach_data );
						}
					}
					$d['code'] = 1;
				}
			}
		}
		echo json_encode($d);
		exit;
	}
	
	add_action('wp_ajax_nopriv_doctor', 'ajax_doctor');
	add_action('wp_ajax_doctor', 'ajax_doctor');
	
	function ajax_doctor(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'user' => array(
				'ID' => 0,
				'name' => '',
				'image' => '',
				'especialidad' => '',
				'telefono' => ''
			)
		);
		if (is_request_method_post()){
			$user_id = 0;
			extract($_POST);
			$user = get_user_by( 'ID', $user_id );
			if($user){
				$doctor = get_user_by( 'ID', $user->doctor);
				$thumbnail = get_theme_image($doctor->user_image);
				$d['code'] = 1;
				$d['user']['ID'] = $doctor->ID;
				$d['user']['name'] = $doctor->first_name.' '.$doctor->last_name;
				$d['user']['image'] = $thumbnail->url;
				$d['user']['email'] = $doctor->user_email;
				$d['user']['telefono'] = $doctor->telefono;
				$d['user']['especialidad'] = $doctor->especialidad;
			}
		}
		echo json_encode($d);
		exit;
	}
	
	add_action('wp_ajax_nopriv_agente', 'ajax_agente');
	add_action('wp_ajax_agente', 'ajax_agente');
	
	function ajax_agente(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'user' => array(
				'ID' => 0,
				'name' => '',
				'image' => '',
				'telefono' => ''
			)
		);
		if (is_request_method_post()){
			$user_id = 0;
			extract($_POST);
			$user = get_user_by( 'ID', $user_id );
			if($user){
				$agente = get_user_by( 'ID', $user->agente);
				$thumbnail = get_theme_image($agente->user_image);
				$d['code'] = 1;
				$d['user']['ID'] = $agente->ID;
				$d['user']['name'] = $agente->first_name.' '.$agente->last_name;
				$d['user']['image'] = $thumbnail->url;
				$d['user']['email'] = $agente->user_email;
				$d['user']['telefono'] = $agente->telefono;
			}
		}
		echo json_encode($d);
		exit;
	}
	
	add_action('wp_ajax_nopriv_login_paquetes', 'ajax_login_paquetes');
	add_action('wp_ajax_login_paquetes', 'ajax_login_paquetes');
	
	function ajax_login_paquetes(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'paquetes' => array()
		);
		if (is_request_method_post()){
			extract($_POST);
			$d['code'] = 1;
			$menu_items = get_nav_menu_items('theme_login_paquetes_menu');
			foreach($menu_items as $menu_item){
				$_post = get_post($menu_item->object_id);
				$paquete['title'] = $_post->post_title;
				$paquete['content'] = apply_filters('the_content', $_post->post_content);
				$paquete['precio'] = format_number($_post->precio);
				$d['paquetes'][] = $paquete;
			}
		}
		echo json_encode($d);
		exit;
	}
	
	add_action('wp_ajax_nopriv_precios', 'ajax_precios');
	add_action('wp_ajax_precios', 'ajax_precios');
	
	function ajax_precios(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'precios' => array()
		);
		if (is_request_method_post()){
			extract($_POST);
			$d['code'] = 1;
			$args = array(
				'posts_per_page' => -1,
				'post_type' => 'precio'
			);
			$precios = get_posts($args);
			foreach($precios as $_post){
				$precio['title'] = $_post->post_title;
				$precio['content'] = apply_filters('the_content', $_post->post_content);
				$precio['precio'] = format_number($_post->precio);
				$d['precios'][] = $precio;
			}
		}
		echo json_encode($d);
		exit;
	}

	add_action('wp_ajax_nopriv_citas', 'ajax_citas');
	add_action('wp_ajax_citas', 'ajax_citas');
	
	function ajax_citas(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'citas_slider' => array(),
			'citas' => array()
		);
		if (is_request_method_post()){
			$user_id = 0;
			extract($_POST);
			$user = get_user_by( 'ID', $user_id );
			if($user){
				$d['code'] = 1;
				//$doctor_id = $user->doctor;
				$time = time();
				$args = array(
					//'author' => $doctor_id,
					'posts_per_page' => -1,
					'post_type' => 'cita',
					'meta_key' => 'fecha',
					'orderby' => 'meta_value',
					'order' => 'ASC',
					'meta_query' => array(
						array(
							'key' => 'paciente',
							'value' => $user_id,
						),
						array(
							'key' => 'fecha',
							'value' => $time,
							'type' => 'numeric',
							'compare' => '>=',
						)
					)
				);
				$citas = get_posts($args);
				foreach($citas as $k => $_post){
					$doctor = get_user_by( 'ID', $_post->post_author);
					$thumbnail = get_theme_image($doctor->user_image);
					$the_date = date('Y-m-d H:i:s', $_post->fecha);
					$date = mysql2date('j M, Y H:i', $the_date);
					//$date = apply_filters( 'get_the_date', $date);
					$cita['title'] = $_post->post_title;
					$cita['content'] = apply_filters('the_content', $_post->post_content);
					$cita['image'] = $thumbnail->url;
					$cita['doctor'] = $doctor->first_name.' '.$doctor->last_name;
					$cita['date'] = $date;
					$d['citas_slider'][] = $cita;
					unset($citas[$k]);
					if($k == 2){
						break;
					}
				}
				foreach($citas as $_post){
					$doctor = get_user_by( 'ID', $_post->post_author);
					$thumbnail = get_theme_image($doctor->user_image);
					$the_date = date('Y-m-d H:i:s', $_post->fecha);
					$date = mysql2date('j M, Y H:i', $the_date);
					//$date = apply_filters( 'get_the_date', $date);
					$cita['title'] = $_post->post_title;
					$cita['content'] = apply_filters('the_content', $_post->post_content);
					$cita['image'] = $thumbnail->url;
					$cita['doctor'] = $doctor->first_name.' '.$doctor->last_name;
					$cita['date'] = $date;
					$d['citas'][] = $cita;
				}
			}
		}
		echo json_encode($d);
		exit;
	}

	add_action('wp_ajax_nopriv_calendario', 'ajax_calendario');
	add_action('wp_ajax_calendario', 'ajax_calendario');
	
	function ajax_calendario(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'calendario' => array()
		);
		if (is_request_method_post()){
			$user_id = 0;
			extract($_POST);
			$user = get_user_by( 'ID', $user_id );
			if($user){
				$d['code'] = 1;
				$time = time();
				$year = date('Y') + 1;
				$last_day = mktime(23, 59, 59, 12, 31, $year);
				$args = array(
					'posts_per_page' => -1,
					'post_type' => 'cita',
					'meta_key' => 'fecha',
					'orderby' => 'meta_value',
					'order' => 'ASC',
					'meta_query' => array(
						array(
							'key' => 'paciente',
							'value' => $user_id,
						),
						array(
							'key' => 'fecha',
							'value' => array($time, $last_day),
							'type' => 'numeric',
							'compare' => 'BETWEEN',
						),
					)
				);
				$citas = get_posts($args);
				foreach($citas as $k => $_post){
					$doctor = get_user_by( 'ID', $_post->post_author);
					$thumbnail = get_theme_image($doctor->user_image);
					$the_date = date('Y-m-d H:i:s', $_post->fecha);
					$date = mysql2date('j M, Y H:i', $the_date);
					$cita['title'] = $_post->post_title;
					$cita['content'] = $doctor->first_name.' '.$doctor->last_name;
					$cita['image'] = $thumbnail->url;
					$cita['date'] = $date;
					$cita['time'] = $_post->fecha;
					$d['calendario'][] = (object)$cita;
				}
				$data = array(
					'calendario' => $d['calendario']
				);
				$d['html'] = load_view('_calendario', $data, true);
			}
		}
		echo json_encode($d);
		exit;
	}

	add_action('wp_ajax_nopriv_actividades', 'ajax_actividades');
	add_action('wp_ajax_actividades', 'ajax_actividades');
	
	function ajax_actividades(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'actividades' => array()
		);
		if (is_request_method_post()){
			$user_id = 0;
			extract($_POST);
			$d['code'] = 1;
			$time = time();
			$args = array(
				'posts_per_page' => -1,
				'post_type' => 'actividad',
				'meta_key' => 'fecha',
				'orderby' => 'meta_value',
				'order' => 'ASC',
				'meta_query' => array(
					array(
						'key' => 'fecha',
						'value' => $time,
						'type' => 'numeric',
						'compare' => '>=',
					),
				)
			);
			$actividades = get_posts($args);
			foreach($actividades as $k => $_post){
				$thumbnail = get_thumbnail($_post);
				$the_date = date('Y-m-d H:i:s', $_post->fecha);
				$date = mysql2date('j M, Y H:i', $the_date);
				$actividad['ID'] = $_post->ID;
				$actividad['title'] = $_post->post_title;
				$actividad['image'] = $thumbnail->url;
				$actividad['date'] = $date;
				$d['actividades'][] = (object)$actividad;
			}

		}
		echo json_encode($d);
		exit;
	}

	add_action('wp_ajax_nopriv_actividad', 'ajax_actividad');
	add_action('wp_ajax_actividad', 'ajax_actividad');
	
	function ajax_actividad(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'actividad' => '',
			'doctor' => '',
			'agente' => ''
		);
		if (is_request_method_post()){
			$user_id = 0;
			extract($_POST);
			$user = get_user_by( 'ID', $user_id );
			if($user){
				$d['code'] = 1;
				$_post = get_post($actividad_id);
				$agente = get_user_by( 'ID', $user->agente);
				$doctor = get_user_by( 'ID', $_post->doctor);

				$thumbnail = get_thumbnail($_post);
				$the_date = date('Y-m-d H:i:s', $_post->fecha);
				$date = mysql2date('j M, Y H:i', $the_date);
				$actividad['ID'] = $_post->ID;
				$actividad['title'] = $_post->post_title;
				$actividad['content'] = apply_filters('the_content', $_post->post_content);
				$actividad['image'] = $thumbnail->url;
				$actividad['date'] = $date;
				$actividad['limite'] = $_post->limite;

				$_doctor['nombre'] = $doctor->first_name.' '.$doctor->last_name;
				$_doctor['especialidad'] = $doctor->especialidad;

				$_agente['nombre'] = $agente->first_name.' '.$agente->last_name;
				$_agente['telefono'] = $agente->telefono;

				$d['actividad'] = (object)$actividad;
				$d['doctor'] = (object)$_doctor;
				$d['agente'] = (object)$_agente;
			}
		}
		echo json_encode($d);
		exit;
	}

	add_action('wp_ajax_nopriv_beneficios', 'ajax_beneficios');
	add_action('wp_ajax_beneficios', 'ajax_beneficios');
	
	function ajax_beneficios(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'beneficios' => ''
		);
		if (is_request_method_post()){
			extract($_POST);
			$_post = get_page_by_path('beneficios-nacer-seguro');
			if($_post){
				$d['code'] = 1;
				$d['title'] = $_post->post_title;
				$d['beneficios'] = apply_filters('the_content', $_post->post_content);
			}
		}
		echo json_encode($d);
		exit;
	}

	add_action('wp_ajax_nopriv_seguro', 'ajax_seguro');
	add_action('wp_ajax_seguro', 'ajax_seguro');
	
	function ajax_seguro(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'seguro' => '',
			'agente' => ''
		);
		if (is_request_method_post()){
			$user_id = 0;
			extract($_POST);
			$user = get_user_by( 'ID', $user_id );
			if($user){
				//if($user->seguro_nombre){
					$seguro_fecha_nacimiento = '';
					$seguro_vida = '';
					if($user->seguro_fecha_nacimiento){
						$seguro_fecha_nacimiento = date('d/m/Y', $user->seguro_fecha_nacimiento);
					}
					if($user->seguro_vida){
						$seguro_vida = date('d/m/Y', $user->seguro_vida);
					}

					$thumbnail = get_theme_image($user->babe_image);
					$image = '';
					if($thumbnail->ID){
						$image = $thumbnail->url;
					}
					$agente = get_user_by( 'ID', $user->agente);

					$d['code'] = 1;
					$seguro['nombre'] = $user->seguro_nombre;
					$seguro['apellidos'] = $user->seguro_apellidos;
					$seguro['fecha_nacimiento'] = $seguro_fecha_nacimiento;
					$seguro['nip'] = $user->seguro_nip;
					$seguro['vida'] = $seguro_vida;
					$seguro['image'] = $image;

					$_agente['nombre'] = $agente->first_name.' '.$agente->last_name;
					$_agente['telefono'] = $agente->telefono;

					$d['seguro'] = $seguro;
					$d['agente'] = (object)$_agente;
				//}
			}
		}
		echo json_encode($d);
		exit;
	}

	add_action('wp_ajax_nopriv_app_file_upload', 'ajax_app_file_upload');
	add_action('wp_ajax_app_file_upload', 'ajax_app_file_upload');
	
	function ajax_app_file_upload(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'url' => '',
			'filename' => '',
			'original' => ''
		);
		if (is_request_method_post()){
	
			extract($_POST);
			extract($_FILES);

			$name = $image['name'];
			$tmp_name = $image['tmp_name'];
			$error = $image['error'];

			if(!$error){
				$w = 540;
				$h = 960;
				$upload_dir = wp_upload_dir();
				$path = $upload_dir['basedir'].'/app';
				$url = $upload_dir['baseurl'].'/app';
				$ext = pathinfo($name, PATHINFO_EXTENSION);
				$filename = random_string('unique');
				$filename = $filename.'.'.$ext;
				$is_move_uploaded = move_uploaded_file($image['tmp_name'], $path.'/'.$filename);
				if($is_move_uploaded){

					$original = $url.'/'.$filename;
					$file_url = get_the_timthumb($original, $w, $h);
					$file_url = str_replace('&amp;', '&', $file_url);

					$filename = random_string('unique');
					$filename = $filename.'.'.$ext;

					if (copy($file_url, $path.'/'.$filename)) {
						$file_url = $url.'/'.$filename;
						$d['code'] = 1;
						$d['url'] = $file_url;
						$d['filename'] = $filename;
						$d['original'] = $original;
					}
				}
			}
		}
		echo json_encode($d);
		exit;
	}

	add_action('wp_ajax_nopriv_app_profile_upload', 'ajax_app_profile_upload');
	add_action('wp_ajax_app_profile_upload', 'ajax_app_profile_upload');
	
	function ajax_app_profile_upload(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'url' => '',
			'filename' => ''
		);
		if (is_request_method_post()){
	
			extract($_POST);
			extract($_FILES);

			$name = $image['name'];
			$tmp_name = $image['tmp_name'];
			$error = $image['error'];

			if(!$error){
				$upload_dir = wp_upload_dir();
				$path = $upload_dir['basedir'].'/app';
				$url = $upload_dir['baseurl'].'/app';
				$ext = pathinfo($name, PATHINFO_EXTENSION);
				$filename = random_string('unique');
				$filename = $filename.'.'.$ext;
				$is_move_uploaded = move_uploaded_file($image['tmp_name'], $path.'/'.$filename);
				if($is_move_uploaded){
					$file_url = $url.'/'.$filename;
					$d['code'] = 1;
					$d['url'] = $file_url;
					$d['filename'] = $filename;
				}
			}
		}
		echo json_encode($d);
		exit;
	}

	add_action('wp_ajax_nopriv_frame', 'ajax_frame');
	add_action('wp_ajax_frame', 'ajax_frame');
	
	function ajax_frame(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'history' => ''
		);
		if (is_request_method_post()){
			$user_id = 0;
			extract($_POST);
			$user = get_user_by( 'ID', $user_id );
			if($user){

				$w = 540;
				$h = 960;
				$upload_dir = wp_upload_dir();
				$path = $upload_dir['basedir'].'/app';
				$url = $upload_dir['baseurl'].'/app';
				$ext = pathinfo($image, PATHINFO_EXTENSION);
				$filename = random_string('unique');
				$filename = $filename.'.'.$ext;

				$image_url = $url.'/'.$image;
				$frame_url = get_template_url().'/images/frames/'.$frame;

				$back_image = imagecreatefromjpeg($image_url);
				$front_image = imagecreatefrompng($frame_url);
				$base_image = imagecreatetruecolor($w, $h);

				imagecopy($base_image, $back_image, 0, 0, 0, 0, $w, $h);
				imagecopy($base_image, $front_image, 0, 0, 0, 0, $w, $h);
				imagejpeg($base_image, $path.'/'.$filename);

		        imagedestroy($image);
		        imagedestroy($back_image);
		        imagedestroy($front_image);

		        $file_url = $url.'/'.$filename;
		        $time = time();

		        $args = array(
		        	'post_title' => $history,
		        	'post_author' => $user->ID,
		        	'post_type' => 'historia',
		        	'post_status' => 'publish'
		        );
		        $r = wp_insert_post($args);
		        if(!is_wp_error($r)){
			        update_post_meta($r, 'fecha', $time);
			        update_post_meta($r, 'image', $file_url);
			        $the_date = date('Y-m-d H:i:s', $time);
					$date = mysql2date('j M, Y H:i', $the_date);
					$d['code'] = 1;
					$_history['ID'] = $r;
			        $_history['title'] = $history;
			        $_history['image'] = $file_url;
					$_history['date'] = $date;
					$d['history'] = $_history;
		        }
		    }
		}
		echo json_encode($d);
		exit;
	}

	add_action('wp_ajax_nopriv_historias', 'ajax_historias');
	add_action('wp_ajax_historias', 'ajax_historias');
	
	function ajax_historias(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'historias' => array()
		);
		if (is_request_method_post()){
			$user_id = 0;
			extract($_POST);
			$d['code'] = 1;
			$time = time();
			$args = array(
				'posts_per_page' => -1,
				'post_type' => 'historia',
				//'meta_key' => 'fecha',
				//'orderby' => 'meta_value',
				//'order' => 'DESC',
				'author' => $user_id
				/*'meta_query' => array(
					array(
						'key' => 'fecha',
						'value' => $time,
						'type' => 'numeric',
						'compare' => '>=',
					),
				)*/
			);
			$historias = get_posts($args);
			foreach($historias as $k => $_post){
				$thumbnail = $_post->image;
				$the_date = date('Y-m-d H:i:s', $_post->fecha);
				$date = mysql2date('j M, Y H:i', $the_date);
				$historia['ID'] = $_post->ID;
				$historia['title'] = $_post->post_title;
				$historia['image'] = $thumbnail;
				$historia['date'] = $date;
				$d['historias'][] = (object)$historia;
			}

		}
		echo json_encode($d);
		exit;
	}
	
	add_action('wp_ajax_nopriv_gestacion', 'ajax_gestacion');
	add_action('wp_ajax_gestacion', 'ajax_gestacion');
	
	function ajax_gestacion(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'gestacion' => array()
		);
		if (is_request_method_post()){
			$user_id = 0;
			extract($_POST);
			$user = get_user_by( 'ID', $user_id );
			if($user){
				$from = $user->ultima_menstruacion;
				$to = time();
				$weeks = weeks_between_dates($from, $to);
				$_weeks = $weeks;
				$month = 0;
				if(!$_weeks){
					$_weeks = 1;
				}
				if($_weeks > 40){
					$_weeks = 40;
				}
				if($_weeks % 4 == 0){
					$month = $_weeks / 4;
					if($month > 9){
						$month = 9;
					}
				}
				if($_weeks % 2 == 0){
					$_weeks--;
				}
				$d1 = $_weeks;
				$d2 = $d1 + 1;
				if($d1 < 10){
					$d1 = '0'.$d1;
				}
				if($d2 < 10){
					$d2 = '0'.$d2;
				}
				$image_month = '';
				if($month){
					$path = 'GestacionM_M0'.$month;
					$_post = get_page_by_path($path, OBJECT, 'gestacion');
					$thumbnail = get_thumbnail($_post);
					$image_month = $thumbnail->url;
				}
				$path = "GestacionSem$d1-$d2";
				$_post = get_page_by_path($path, OBJECT, 'gestacion');
				$thumbnail = get_thumbnail($_post);
				$degrees = 360 / 39;
				$d['code'] = 1;
				$d['gestacion']['month'] = month_name(date('n', $to));
				$d['gestacion']['year'] = date('Y', $to);
				$d['gestacion']['image'] = $thumbnail->url;
				$d['gestacion']['image_month'] = $image_month;
				$d['gestacion']['weeks'] = $weeks;
				$d['gestacion']['degrees'] = $degrees * $_weeks;
				$d['gestacion']['description'] = apply_filters('the_content', $_post->post_content);
			}
		}
		echo json_encode($d);
		exit;
	}
	
	add_action('wp_ajax_nopriv_historia', 'ajax_historia');
	add_action('wp_ajax_historia', 'ajax_historia');
	
	function ajax_historia(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'historia' => array()
		);
		if (is_request_method_post()){
			$user_id = 0;
			$historia_id = 0;
			extract($_POST);
			$d['code'] = 1;
			$_post = get_post($historia_id);
			$thumbnail = $_post->image;
			$the_date = date('Y-m-d H:i:s', $_post->fecha);
			$date = mysql2date('j M, Y H:i', $the_date);
			$historia['ID'] = $_post->ID;
			$historia['title'] = $_post->post_title;
			$historia['image'] = $thumbnail;
			$historia['date'] = $date;
			$d['historia'] = (object)$historia;

		}
		echo json_encode($d);
		exit;
	}

	add_action('wp_ajax_nopriv_notificaciones', 'ajax_notificaciones');
	add_action('wp_ajax_notificaciones', 'ajax_notificaciones');
	
	function ajax_notificaciones(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0,
			'notificaciones' => array()
		);
		if (is_request_method_post()){
			$user_id = 0;
			extract($_POST);
			$d['code'] = 1;
			$time = time();
			$args = array(
				'posts_per_page' => -1,
				'post_type' => 'notification',
				'meta_key' => 'fecha',
				'orderby' => 'meta_value',
				'order' => 'DESC',
				'meta_query' => array(
					array(
						'key' => 'paciente',
						'value' => $user_id
					)
				)
			);
			$actividades = get_posts($args);
			foreach($actividades as $k => $_post){
				$thumbnail = get_thumbnail($_post);
				$the_date = date('Y-m-d H:i:s', $_post->fecha);
				$date = mysql2date('j M, Y H:i', $the_date);
				$notification['ID'] = $_post->ID;
				$notification['title'] = $_post->post_title;
				$notification['date'] = $date;
				$d['notificaciones'][] = (object)$notification;
			}
		}
		echo json_encode($d);
		exit;
	}
	
	add_action('wp_ajax_nopriv_eliminar_historia', 'ajax_eliminar_historia');
	add_action('wp_ajax_eliminar_historia', 'ajax_eliminar_historia');
	
	function ajax_eliminar_historia(){
		header("Access-Control-Allow-Origin: *");
		header('content-type: application/json');
		$d = array(
			'code' => 0
		);
		if (is_request_method_post()){
			$user_id = 0;
			$historia_id = 0;
			extract($_POST);
			$d['code'] = 1;
			wp_delete_post($historia_id, true);
		}
		echo json_encode($d);
		exit;
	}










	function weeks_between_dates($from, $to){
		$d = 0;
		$seconds = $to - $from;
		$minutes = $seconds / 60;
		$hours = $minutes / 60;
		$days = floor($hours / 24);
		$weeks = floor($days / 7);
		$d = $weeks;
		return $d;
	}

	function send_notification_ios($deviceToken, $message){
		$d = false;
		$passphrase = 'hplm1.';
		$ctx = stream_context_create();
		stream_context_set_option($ctx, 'ssl', 'local_cert', get_template_path().'/certs/HPLMCK.pem');
		stream_context_set_option($ctx, 'ssl', 'passphrase', $passphrase);
		$fp = stream_socket_client('ssl://gateway.sandbox.push.apple.com:2195', $err, $errstr, 60, STREAM_CLIENT_CONNECT|STREAM_CLIENT_PERSISTENT, $ctx);
		if (!$fp) {
			exit;
		}
		$body['aps'] = array(
			'alert' => $message,
			'sound' => 'bingbong.aiff'
		);
		$payload = json_encode($body);
		$msg = chr(0) . pack('n', 32) . pack('H*', $deviceToken) . pack('n', strlen($payload)) . $payload;
		$result = fwrite($fp, $msg, strlen($msg));
		if (!$result) {
			$d = false;
		} else { 
			$d = true;
		}
		fclose($fp);
		return $d;
	}

	function send_notification_android($deviceToken, $title, $message){
		$d = false;
		$api_access_key = 'AIzaSyBndlHRBWsyd6d73Zt20yT2Vira2_js6jU';
		$fcmUrl = 'https://fcm.googleapis.com/fcm/send';
		$token = $deviceToken;
		$notification = [
			'title' => $title,
			'body' => $message,
			'icon' => 'myicon'
		];
		$fcmNotification = [
			'to' => $token,
			'notification' => $notification
		];
		$headers = [
			'Authorization: key='.$api_access_key,
			'Content-Type: application/json'
		];
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$fcmUrl);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fcmNotification));
		$result = curl_exec($ch);
		curl_close($ch);
		$json = json_decode($result);
		if($json->success){
			$d = true;
		}
		return $d;
	}

	function custom_user_profile_fields($user) {

		$html = '';
		if(is_the_user_doctor($user)){
			$thumbnail1 = get_theme_image($user->user_image);
			$class1 = '';
			if($thumbnail1->ID){
				$class1 = ' active';
			}
			$html = '
				<h2>Datos del usuario</h2>
				<table class="form-table">
					<tr>
						<th>
							<label>Imagen de perfil</label>
						</th>
						<td>
							<button class="button add-custom-theme-image" type="button" data-img="#user-img" data-input="#user-image">Agregar / Editar imagen</button>
							<img src="'.$thumbnail1->url.'" class="custom-theme-img'.$class1.'" id="user-img" />
							<a href="#" data-img="#user-img" data-input="#user-image" class="remove-custom-theme-image">Quitar imagen</a>
							<input type="hidden" value="'.$thumbnail1->ID.'" id="user-image" name="user_image">
						</td>
					</tr>
					<tr>
						<th>
							<label>Teléfono</label>
						</th>
						<td>
							<input type="text" value="'.$user->telefono.'" name="telefono" class="regular-text" />
						</td>
					</tr>
					<tr>
						<th>
							<label>Especialidad</label>
						</th>
						<td>
							<input type="text" value="'.$user->especialidad.'" name="especialidad" class="regular-text" />
						</td>
					</tr>
				</table>
			';
		}
		if(is_the_user_agente($user)){
			$thumbnail1 = get_theme_image($user->user_image);
			$class1 = '';
			if($thumbnail1->ID){
				$class1 = ' active';
			}
			$html = '
				<h2>Datos del usuario</h2>
				<table class="form-table">
					<tr>
						<th>
							<label>Imagen de perfil</label>
						</th>
						<td>
							<button class="button add-custom-theme-image" type="button" data-img="#user-img" data-input="#user-image">Agregar / Editar imagen</button>
							<img src="'.$thumbnail1->url.'" class="custom-theme-img'.$class1.'" id="user-img" />
							<a href="#" data-img="#user-img" data-input="#user-image" class="remove-custom-theme-image">Quitar imagen</a>
							<input type="hidden" value="'.$thumbnail1->ID.'" id="user-image" name="user_image">
						</td>
					</tr>
					<tr>
						<th>
							<label>Teléfono</label>
						</th>
						<td>
							<input type="text" value="'.$user->telefono.'" name="telefono" class="regular-text" />
						</td>
					</tr>
				</table>
			';
		}
		if(is_the_user_subscriber($user)){

			$thumbnail1 = get_theme_image($user->user_image);
			$thumbnail2 = get_theme_image($user->babe_image);
			$class1 = '';
			$class2 = '';
			if($thumbnail1->ID){
				$class1 = ' active';
			}
			if($thumbnail2->ID){
				$class2 = ' active';
			}
			$options_sexo = '';
			foreach (array('F', 'M') as $sexo) {
				$selected = '';
				if($user->sexo == $sexo){
					$selected = 'selected';
				}
				$options_sexo .= '<option '.$selected.' value="'.$sexo.'">'.$sexo.'</option>';
			}
			$dia = date('d/m/Y');
			$ultima_menstruacion = date('d/m/Y');
			$hora = $user->hora;
			$minuto = $user->minuto;
			if($user->dia){
				$dia = date('d/m/Y', $user->dia);
			}
			if($user->ultima_menstruacion){
				$ultima_menstruacion = date('d/m/Y', $user->ultima_menstruacion);
			}
			$options_hora = '';
			$options_minuto = '';
			for($i = 0; $i < 60; $i++){
				$v = $i;
				if($i < 10){
					$v = '0'.$i;
				}
				$selected1 = '';
				$selected2 = '';
				if($user->hora == $i){
					$selected1 = 'selected';
				}
				if($user->minuto == $i){
					$selected2 = 'selected';
				}
				$options_hora .= '<option '.$selected1.' value="'.$i.'">'.$v.'</option>';
				$options_minuto .= '<option '.$selected2.' value="'.$i.'">'.$v.'</option>';
			}
			$options_doctor = '';
			$args_doctor = array(
				'role' => 'doctor'
			);
			$doctores = get_users($args_doctor);
			foreach($doctores as $doctor){
				$selected = '';
				if($user->doctor == $doctor->ID){
					$selected = 'selected';
				}
				$options_doctor .= '<option '.$selected.' value="'.$doctor->ID.'">'.$doctor->first_name.' '.$doctor->last_name.'</option>';
			}
			$options_agente = '';
			$args_agente = array(
				'role' => 'agente'
			);
			$agentes = get_users($args_agente);
			foreach($agentes as $agente){
				$selected = '';
				if($user->agente == $agente->ID){
					$selected = 'selected';
				}
				$options_agente .= '<option '.$selected.' value="'.$agente->ID.'">'.$agente->first_name.' '.$agente->last_name.'</option>';
			}


			$seguro_fecha_nacimiento = '';
			$seguro_vida = '';
			if($user->seguro_fecha_nacimiento){
				$seguro_fecha_nacimiento = date('d/m/Y', $user->seguro_fecha_nacimiento);
			}
			if($user->seguro_vida){
				$seguro_vida = date('d/m/Y', $user->seguro_vida);
			}


			$html = '
				<h2>Datos del usuario</h2>
				<table class="form-table">
					<tr>
						<th>
							<label>Imagen de perfil</label>
						</th>
						<td>
							<button class="button add-custom-theme-image" type="button" data-img="#user-img" data-input="#user-image">Agregar / Editar imagen</button>
							<img src="'.$thumbnail1->url.'" class="custom-theme-img'.$class1.'" id="user-img" />
							<a href="#" data-img="#user-img" data-input="#user-image" class="remove-custom-theme-image">Quitar imagen</a>
							<input type="hidden" value="'.$thumbnail1->ID.'" id="user-image" name="user_image">
						</td>
					</tr>
					<tr>
						<th>
							<label>Teléfono</label>
						</th>
						<td>
							<input type="text" value="'.$user->telefono.'" name="telefono" class="regular-text" />
						</td>
					</tr>
					<tr>
						<th>
							<label>Dirección</label>
						</th>
						<td>
							<textarea name="direccion">'.$user->direccion.'</textarea>
						</td>
					</tr>
					<tr>
						<th>
							<label>Última mestruación</label>
						</th>
						<td>
							<input type="text" value="'.$ultima_menstruacion.'" name="ultima_menstruacion" class="regular-text datepicker" />
						</td>
					</tr>
					<tr>
						<th>
							<label>Doctor</label>
						</th>
						<td>
							<select name="doctor" class="regular-text">
								<option value="">Seleccione</option>
								'.$options_doctor.'
							</select>
						</td>
					</tr>
					<tr>
						<th>
							<label>Agente</label>
						</th>
						<td>
							<select name="agente" class="regular-text">
								<option value="">Seleccione</option>
								'.$options_agente.'
							</select>
						</td>
					</tr>
				</table>
				<h2>Datos del niño</h2>
				<table class="form-table">
					<tr>
						<th>
							<label>Imagen de perfil</label>
						</th>
						<td>
							<button class="button add-custom-theme-image" type="button" data-img="#babe-img" data-input="#babe-image">Agregar / Editar imagen</button>
							<img src="'.$thumbnail2->url.'" class="custom-theme-img'.$class2.'" id="babe-img" />
							<a href="#" data-img="#babe-img" data-input="#babe-image" class="remove-custom-theme-image">Quitar imagen</a>
							<input type="hidden" value="'.$thumbnail2->ID.'" id="babe-image" name="babe_image">
						</td>
					</tr>
					<tr>
						<th>
							<label>Nombre del padre</label>
						</th>
						<td>
							<input type="text" value="'.$user->padre.'" name="padre" class="regular-text" />
						</td>
					</tr>
					<tr>
						<th>
							<label>Sexo</label>
						</th>
						<td>
							<select name="sexo" class="regular-text">
								<option value="">Seleccione</option>
								'.$options_sexo.'
							</select>
						</td>
					</tr>
					<tr>
						<th>
							<label>Peso</label>
						</th>
						<td>
							<input type="text" value="'.$user->peso.'" name="peso" class="regular-text" />
						</td>
					</tr>
					<tr>
						<th>
							<label>Talla</label>
						</th>
						<td>
							<input type="text" value="'.$user->talla.'" name="talla" class="regular-text" />
						</td>
					</tr>
					<tr>
						<th>
							<label>Día</label>
						</th>
						<td>
							<input type="text" value="'.$dia.'" name="dia" class="regular-text datepicker" />
						</td>
					</tr>
					<tr>
						<th>
							<label>Hora</label>
						</th>
						<td>
							<select name="hora">
								'.$options_hora.'
							</select>
							<select name="minuto">
								'.$options_minuto.'
							</select>
						</td>
					</tr>
				</table>
				<h2>Nacer Seguro</h2>	
				<table class="form-table">	
					<tr>
						<th>
							<label>Nombre</label>
						</th>
						<td>
							<input type="text" value="'.$user->seguro_nombre.'" name="seguro_nombre" class="regular-text" />
						</td>
					</tr>
					<tr>
						<th>
							<label>Apellidos</label>
						</th>
						<td>
							<input type="text" value="'.$user->seguro_apellidos.'" name="seguro_apellidos" class="regular-text" />
						</td>
					</tr>
					<tr>
						<th>
							<label>Fecha de nacimiento</label>
						</th>
						<td>
							<input type="text" name="seguro_fecha_nacimiento" value="'.$seguro_fecha_nacimiento.'" class="datepicker" />	
						</td>
					</tr>
					<tr>
						<th>
							<label>NIP</label>
						</th>
						<td>
							<input type="text" value="'.$user->seguro_nip.'" name="seguro_nip" class="regular-text" />
						</td>
					</tr>
					<tr>
						<th>
							<label>Vida del seguro</label>
						</th>
						<td>
							<input type="text" name="seguro_vida" value="'.$seguro_vida.'" class="datepicker" />	
						</td>
					</tr>
				</table>
			';
		}

		echo $html;
	}
		
	add_action('show_user_profile', 'custom_user_profile_fields');
	add_action('edit_user_profile', 'custom_user_profile_fields');
	
	add_action( 'personal_options_update', 'update_custom_profile_fields' );
	add_action( 'edit_user_profile_update', 'update_custom_profile_fields' );

	function update_custom_profile_fields( $user_id ){
		extract($_POST);
		if(is_the_user_doctor($user_id)){
			update_user_meta( $user_id, 'user_image', $user_image);
			update_user_meta( $user_id, 'telefono', $telefono);
			update_user_meta( $user_id, 'especialidad', $especialidad);
		}
		if(is_the_user_agente($user_id)){
			update_user_meta( $user_id, 'user_image', $user_image);
			update_user_meta( $user_id, 'telefono', $telefono);
		}
		if(is_the_user_subscriber($user_id)){
			$_hora = $hora;
			$_minuto = $minuto;
			if($hora < 10){
				$_hora = '0'.$hora;
			}
			if($minuto < 10){
				$_minuto = '0'.$minuto;
			}
			$diayhora = $dia.' '.$_hora.':'.$_minuto;
			$_dia = explode('/', $dia);
			$menstruacion = $ultima_menstruacion;
			$_ultima_menstruacion = explode('/', $ultima_menstruacion);
			$dia = mktime(0, 0, 0, (int)$_dia[1], (int)$_dia[0], (int)$_dia[2]);
			$ultima_menstruacion = mktime(0, 0, 0, (int)$_ultima_menstruacion[1], (int)$_ultima_menstruacion[0], (int)$_ultima_menstruacion[2]);

			if($seguro_fecha_nacimiento){
				$_seguro_fecha_nacimiento = explode('/', $seguro_fecha_nacimiento);
				$seguro_fecha_nacimiento = mktime(0, 0, 0, (int)$_seguro_fecha_nacimiento[1], (int)$_seguro_fecha_nacimiento[0], (int)$_seguro_fecha_nacimiento[2]);
			}
			if($seguro_vida){
				$_seguro_vida = explode('/', $seguro_vida);
				$seguro_vida = mktime(0, 0, 0, (int)$_seguro_vida[1], (int)$_seguro_vida[0], (int)$_seguro_vida[2]);
			}

			update_user_meta( $user_id, 'user_image', $user_image);
			update_user_meta( $user_id, 'telefono', $telefono);
			update_user_meta( $user_id, 'direccion', $direccion);
			update_user_meta( $user_id, 'ultima_menstruacion', $ultima_menstruacion);
			update_user_meta( $user_id, 'menstruacion', $menstruacion);
			update_user_meta( $user_id, 'babe_image', $babe_image);
			update_user_meta( $user_id, 'padre', $padre);
			update_user_meta( $user_id, 'sexo', $sexo);
			update_user_meta( $user_id, 'peso', $peso);
			update_user_meta( $user_id, 'talla', $talla);
			update_user_meta( $user_id, 'dia', $dia);
			update_user_meta( $user_id, 'hora', $hora);
			update_user_meta( $user_id, 'minuto', $minuto);
			update_user_meta( $user_id, 'diayhora', $diayhora);
			update_user_meta( $user_id, 'doctor', $doctor);
			update_user_meta( $user_id, 'agente', $agente);

			update_user_meta( $user_id, 'seguro_nombre', $seguro_nombre);
			update_user_meta( $user_id, 'seguro_apellidos', $seguro_apellidos);
			update_user_meta( $user_id, 'seguro_fecha_nacimiento', $seguro_fecha_nacimiento);
			update_user_meta( $user_id, 'seguro_nip', $seguro_nip);
			update_user_meta( $user_id, 'seguro_vida', $seguro_vida);
		}
	}
	
	function is_the_user_doctor($user_id = false){
		$d = is_the_user('doctor', $user_id);
		return $d;
	}

	function is_the_user_agente($user_id = false){
		$d = is_the_user('agente', $user_id);
		return $d;
	}

	function custom_pre_get_users( $query ) { 
		$screen = get_current_screen();
		if(is_admin() && is_the_user_doctor() && $screen->base == 'users'){
			$current_user = wp_get_current_user();
			$query->set( 'meta_key', 'doctor' );
	    	$query->set( 'meta_value', $current_user->ID );
			//echo '<style> #adminmenumain{ display: none; } </style>';
		}
	}
	         
	add_action('pre_get_users', 'custom_pre_get_users', 10, 1); 

    $args_paquete = array(
        'label' => 'Paquetes',
        'labels' => array(
            'name' => 'Paquetes',
            'all_items' => 'Paquetes',
            'singular_name' => 'Paquete',
            'add_new' => 'Añadir nuevo',
            'add_new_item' => 'Agregar nuevo Paquete',
            'edit_item' => 'Editar Paquete'
        ),
        'public' => false,
        'show_ui' => true,
        'show_in_nav_menus' => true,
        'hierarchical' => false,
        'rewrite' => true,
        'supports' => array(
            'title',
            'editor',
            'author',
            'thumbnail'
        )
    );

    register_post_type('paquete', $args_paquete);

    $args_precio = array(
        'label' => 'Precios',
        'labels' => array(
            'name' => 'Precios',
            'all_items' => 'Precios',
            'singular_name' => 'Precio',
            'add_new' => 'Añadir nuevo',
            'add_new_item' => 'Agregar nuevo Precio',
            'edit_item' => 'Editar Precio'
        ),
        'public' => false,
        'show_ui' => true,
        'show_in_nav_menus' => true,
        'hierarchical' => false,
        'rewrite' => true,
        'supports' => array(
            'title',
            'editor',
            'author',
            'thumbnail'
        )
    );

    register_post_type('precio', $args_precio);
	
	function metabox_precio_callback( $post ) {
		$precio = $post->precio;
		$html = '
			<table>
				<tr>
					<th>Precio:</th>
					<td><input type="text" name="precio" value="'.$precio.'" class="form-control" /></td>
				</tr>
			</table>
		';
		echo $html;
	}
	
	function save_metabox_precio($post_id){
		if (is_request_method_post()){
			$posts = array('paquete', 'precio');
			if (!in_array($_POST['post_type'], $posts)) {
				return $post_id;
			}
			$precio = '';
			extract($_POST);
			if($action == 'editpost'){ //inline-save
				update_post_meta($post_id, 'precio', $precio);
			}
		}
	}
	
	add_action( 'save_post', 'save_metabox_precio' );

    register_post_type('paquete', $args_paquete);

    $args_cita = array(
        'label' => 'Citas',
        'labels' => array(
            'name' => 'Citas',
            'all_items' => 'Citas',
            'singular_name' => 'Cita',
            'add_new' => 'Añadir nueva',
            'add_new_item' => 'Agregar nueva Cita',
            'edit_item' => 'Editar Cita'
        ),
        'public' => false,
        'show_ui' => true,
        'show_in_nav_menus' => true,
        'hierarchical' => false,
        'rewrite' => true,
        'capability_type' => 'cita',
        'map_meta_cap' => true,
        'supports' => array(
            'title',
            'editor',
            //'author',
            //'thumbnail'
        )
    );

    register_post_type('cita', $args_cita);
	
	function metabox_cita_callback( $post ) {
		$_fecha = $post->fecha;
		$fecha = date('d/m/Y');
		$hora = (int)date('H');
		$minuto = (int)date('i');
		if($_fecha){
			$fecha = date('d/m/Y', $_fecha);
			$hora = (int)date('H', $_fecha);
			$minuto = (int)date('i', $_fecha);
		}
		$options_hora = '';
		$options_minuto = '';
		for($i = 0; $i < 60; $i++){
			$v = $i;
			if($i < 10){
				$v = '0'.$i;
			}
			$selected1 = '';
			$selected2 = '';
			if($hora == $i){
				$selected1 = 'selected';
			}
			if($minuto == $i){
				$selected2 = 'selected';
			}
			$options_hora .= '<option '.$selected1.' value="'.$i.'">'.$v.'</option>';
			$options_minuto .= '<option '.$selected2.' value="'.$i.'">'.$v.'</option>';
		}

		$current_user_id = get_current_user_id();
		$options_doctor = '';
		$args_doctor = array(
			'role' => 'doctor'
		);
		$doctores = get_users($args_doctor);
		foreach($doctores as $doctor){
			$selected = '';
			if($post->post_author){
				if($post->post_author == $doctor->ID){
					$selected = 'selected';
				}
			}
			$options_doctor .= '<option '.$selected.' value="'.$doctor->ID.'">'.$doctor->first_name.' '.$doctor->last_name.'</option>';
		}
		$options_paciente = '';
		$args_paciente = array(
			'role' => 'subscriber'
		);
		$pacientes = get_users($args_paciente);
		foreach($pacientes as $paciente){
			$selected = '';
			if($post->paciente){
				if($post->paciente == $paciente->ID){
					$selected = 'selected';
				}
			}
			$options_paciente .= '<option '.$selected.' value="'.$paciente->ID.'">'.$paciente->first_name.' '.$paciente->last_name.'</option>';
		}
		$tr = '
			<tr>
				<th align="right">Doctor:</th>
				<td>		
					<select name="doctor">
						<option value="">Seleccione</option>
						'.$options_doctor.'
					</select>
				</td>
			</tr>
		';
		if(is_the_user_doctor()){
			$tr = '';
			echo '<input type="hidden" name="doctor" value="'.$current_user_id.'" />';
		}
		$html = '
			<table>
				<tr>
					<th align="right">Fecha:</th>
					<td>
						<input type="text" name="fecha" value="'.$fecha.'" class="datepicker" />	
						<select name="hora">
							'.$options_hora.'
						</select>
						<select name="minuto">
							'.$options_minuto.'
						</select>
					</td>
				</tr>
				'.$tr.'
				<tr>
					<th align="right">Paciente:</th>
					<td>		
						<select name="paciente">
							<option value="">Seleccione</option>
							'.$options_paciente.'
						</select>
					</td>
				</tr>
			</table>
		';
		echo $html;
	}
	
	function save_metabox_cita($post_id){
		if (is_request_method_post()){
			$posts = array('cita');
			if (!in_array($_POST['post_type'], $posts)) {
				return $post_id;
			}
			$hora = 0;
			$minuto = 0;
			$fecha = '';
			$doctor = '';
			$paciente = '';
			extract($_POST);
			if($action == 'editpost'){ //inline-save
				$_fecha = explode('/', $fecha);
				$fecha = mktime($hora, $minuto, 0, (int)$_fecha[1], (int)$_fecha[0], (int)$_fecha[2]);
				update_post_meta($post_id, 'fecha', $fecha);
				update_post_meta($post_id, 'paciente', $paciente);
				remove_action( 'save_post', 'save_metabox_cita');
				if(!$doctor){
					$doctor = get_current_user_id();
				}
				$args = array(
					'ID' => $post_id, 
					'post_author' => $doctor
				);
				wp_update_post($args);
				if($original_post_status != 'publish' && $paciente){
					$registration_ids = get_user_meta($paciente, 'registration_id');
					$notification_title = 'Cita';
					$notification_message = $post_title.' el '.date('d/m/Y H:i', $fecha);
					$args = array(
			        	'post_title' => $notification_title.': '.$notification_message,
			        	'post_type' => 'notification',
			        	'post_status' => 'publish'
			        );
			        $r = wp_insert_post($args);
			        if(!is_wp_error($r)){
				        update_post_meta($r, 'fecha', time());
				        update_post_meta($r, 'paciente', $paciente);
				        update_post_meta($r, 'cita', $post_id);
			        }
					if($registration_ids){
						foreach($registration_ids as $registration_id){
							$json = json_decode($registration_id);
							if($json){
								if($json->platform == 'iOS'){
									send_notification_ios($json->id, $notification_title.': '.$notification_message);
								}
								if($json->platform == 'Android'){
									send_notification_android($json->id, $notification_title, $notification_message);
								}
							}
						}
					}
				}
				add_action( 'save_post', 'save_metabox_cita');
			}
		}
	}
	
	add_action( 'save_post', 'save_metabox_cita' );

	add_filter( 'manage_edit-cita_columns', 'custom_manage_edit_cita_columns' );
	add_action( 'manage_cita_posts_custom_column' , 'custom_manage_cita_posts_custom_column', 10, 2 );

	function custom_manage_edit_cita_columns($columns) {
		$date = $columns['date'];
		unset($columns['date']);
		$columns['custom-author'] = 'Doctor'; 
		$columns['custom-date'] = 'Cita';
		$columns['date'] = $date;
		return $columns;
	}

	function custom_manage_cita_posts_custom_column( $column, $post_id) {
		if($column == 'custom-author'){
			global $post;
			if($post->post_author){
				$doctor = get_user_by('ID', $post->post_author);
				echo $doctor->first_name.' '.$doctor->last_name;
			}
		}
		if($column == 'custom-date'){
			global $post;
			$fecha = $post->fecha;
			if($fecha){
				echo date('d/m/Y H:i', $fecha);
			}
		}
	}

    $args_actividad = array(
        'label' => 'Actividades',
        'labels' => array(
            'name' => 'Actividades',
            'all_items' => 'Actividades',
            'singular_name' => 'Actividad',
            'add_new' => 'Añadir nueva',
            'add_new_item' => 'Agregar nueva Actividad',
            'edit_item' => 'Editar Actividad'
        ),
        'public' => false,
        'show_ui' => true,
        'show_in_nav_menus' => true,
        'hierarchical' => false,
        'rewrite' => true,
        'capability_type' => 'actividad',
        'map_meta_cap' => true,
        'supports' => array(
            'title',
            'editor',
            //'author',
            'thumbnail'
        )
    );

    register_post_type('actividad', $args_actividad);

	function metabox_actividad_callback( $post ) {
		$_fecha = $post->fecha;
		$fecha = date('d/m/Y');
		$hora = (int)date('H');
		$minuto = (int)date('i');
		$limite = $post->limite;
		if($_fecha){
			$fecha = date('d/m/Y', $_fecha);
			$hora = (int)date('H', $_fecha);
			$minuto = (int)date('i', $_fecha);
		}
		$options_hora = '';
		$options_minuto = '';
		for($i = 0; $i < 60; $i++){
			$v = $i;
			if($i < 10){
				$v = '0'.$i;
			}
			$selected1 = '';
			$selected2 = '';
			if($hora == $i){
				$selected1 = 'selected';
			}
			if($minuto == $i){
				$selected2 = 'selected';
			}
			$options_hora .= '<option '.$selected1.' value="'.$i.'">'.$v.'</option>';
			$options_minuto .= '<option '.$selected2.' value="'.$i.'">'.$v.'</option>';
		}

		$asistentes = get_post_meta($post->ID, 'asistente');
		$asistentes_html = '';
		foreach($asistentes as $asistente){
			$user = get_user_by('ID', $asistente);
			$name = $user->first_name.' '.$user->last_name;
			$asistentes_html .= '
				<div>
					<span>'.$name.'</span>
					<a href="#" class="remove-asistente"><span class="dashicons dashicons-dismiss"></span></a>
					<input type="hidden" name="asistentes[]" value="'.$asistente.'" />
				</div>
			';
		}
		$options_doctor = '';
		$args_doctor = array(
			'role' => 'doctor'
		);
		$doctores = get_users($args_doctor);
		foreach($doctores as $doctor){
			$selected = '';
			if($post->doctor){
				if($post->doctor == $doctor->ID){
					$selected = 'selected';
				}
			}
			$options_doctor .= '<option '.$selected.' value="'.$doctor->ID.'">'.$doctor->first_name.' '.$doctor->last_name.'</option>';
		}
		$options_paciente = '';
		$args_paciente = array(
			'role' => 'subscriber'
		);
		$pacientes = get_users($args_paciente);
		foreach($pacientes as $paciente){
			$options_paciente .= '<option value="'.$paciente->ID.'">'.$paciente->first_name.' '.$paciente->last_name.'</option>';
		}
		$html = '
			<table>
				<tr>
					<th align="right">Asistentes:</th>
					<td>		
						<select id="asistente-select">
							<option value="">Seleccione</option>
							'.$options_paciente.'
						</select>
						<button class="button" type="button" id="add-asistente">Agregar asistente</button>
					</td>
				</tr>
				<tr>
					<th align="right"></th>
					<td>
						<div id="asistentes" class="asistentes">'.$asistentes_html.'</div>
					</td>
				</tr>
				<tr>
					<th align="right">Fecha:</th>
					<td>
						<input type="text" name="fecha" value="'.$fecha.'" class="datepicker" />	
						<select name="hora">
							'.$options_hora.'
						</select>
						<select name="minuto">
							'.$options_minuto.'
						</select>
					</td>
				</tr>
				<tr>
					<th align="right">Doctor:</th>
					<td>		
						<select name="doctor">
							<option value="">Seleccione</option>
							'.$options_doctor.'
						</select>
					</td>
				</tr>
				<tr>
					<th align="right">Límite:</th>
					<td>		
						<input type="text" name="limite" value="'.$limite.'" />
					</td>
				</tr>
			</table>
		';
		echo $html;
	}

	function save_metabox_actividad($post_id){
		if (is_request_method_post()){
			$posts = array('actividad');
			if (!in_array($_POST['post_type'], $posts)) {
				return $post_id;
			}
			$fecha = '';
			$doctor = '';
			$limite = '';
			$asistentes = array();
			extract($_POST);
			if($action == 'editpost'){ //inline-save
				$_fecha = explode('/', $fecha);
				$fecha = mktime($hora, $minuto, 0, (int)$_fecha[1], (int)$_fecha[0], (int)$_fecha[2]);
				update_post_meta($post_id, 'fecha', $fecha);
				update_post_meta($post_id, 'doctor', $doctor);
				update_post_meta($post_id, 'limite', $limite);
				$asistentes = array_unique($asistentes);
				delete_post_meta($post_id, 'asistente');
				foreach($asistentes as $asistente){
					add_post_meta($post_id, 'asistente', $asistente);
				}

				if($original_post_status != 'publish'){
					remove_action( 'save_post', 'save_metabox_actividad');
					$users = get_users(array('role' => 'subscriber'));
					$notification_title = 'Actividad';
					$notification_message = $post_title.' el '.date('d/m/Y H:i', $fecha);
					$args = array(
			        	'post_title' => $notification_title.': '.$notification_message,
			        	'post_type' => 'notification',
			        	'post_status' => 'publish'
			        );
			        $r = wp_insert_post($args);
			        if(!is_wp_error($r)){
				        update_post_meta($r, 'fecha', time());
				        update_post_meta($r, 'actividad', $post_id);
			        }
					foreach($users as $user){
						$paciente = $user->ID;
						$registration_ids = get_user_meta($paciente, 'registration_id');
						if(!is_wp_error($r)){
					        add_post_meta($r, 'paciente', $paciente);
				        }
						if($registration_ids){
							foreach($registration_ids as $registration_id){
								$json = json_decode($registration_id);
								if($json){
									if($json->platform == 'iOS'){
										send_notification_ios($json->id, $notification_title.': '.$notification_message);
									}
									if($json->platform == 'Android'){
										send_notification_android($json->id, $notification_title, $notification_message);
									}
								}
							}
						}
					}
					add_action( 'save_post', 'save_metabox_actividad');
				}

			}
		}
	}

	add_action( 'save_post', 'save_metabox_actividad' );

    $args_historia = array(
        'label' => 'Historias',
        'labels' => array(
            'name' => 'Historias',
            'all_items' => 'Historias',
            'singular_name' => 'Historia',
            'add_new' => 'Añadir nueva',
            'add_new_item' => 'Agregar nueva Historia',
            'edit_item' => 'Editar Historia'
        ),
        'public' => false,
        'show_ui' => true,
        'show_in_nav_menus' => true,
        'hierarchical' => false,
        'rewrite' => true,
        'supports' => array(
            'title',
            //'editor',
            'author',
            //'thumbnail'
        )
    );

    register_post_type('historia', $args_historia);

    $args_notification = array(
        'label' => 'Notificaciones',
        'labels' => array(
            'name' => 'Notificaciones',
            'all_items' => 'Notificaciones',
            'singular_name' => 'Notificación',
            'add_new' => 'Añadir nueva',
            'add_new_item' => 'Agregar nueva Notificación',
            'edit_item' => 'Editar Notificación'
        ),
        'public' => false,
        'show_ui' => false,
        'hierarchical' => false,
        'rewrite' => true,
        'map_meta_cap' => true,
        'supports' => array(
            'title',
        )
    );

    register_post_type('notification', $args_notification);

    $args_gestacion = array(
        'label' => 'Gestación',
        'labels' => array(
            'name' => 'Gestación',
            'all_items' => 'Gestación',
            'singular_name' => 'Gestación',
            'add_new' => 'Añadir nueva',
            'add_new_item' => 'Agregar nueva Gestación',
            'edit_item' => 'Editar Gestación'
        ),
        'public' => false,
        'show_ui' => true,
        'show_in_nav_menus' => true,
        'hierarchical' => false,
        'rewrite' => true,
        'supports' => array(
            'title',
            'editor',
            'author',
            'thumbnail'
        )
    );

    register_post_type('gestacion', $args_gestacion);










	function add_roles(){
		remove_role('doctor');
		remove_role('agente');
		$result1 = add_role(
		    'doctor',
		    'Doctor',
		    array(
		        'read' => true,
		        'list_users' => true,
		        'edit_users' => true,
		        'edit_citas' => true,
		        'edit_cita' => true,
				'read_cita' => true,
				'publish_citas' => true,
				'delete_cita' => true,
				'delete_citas' => true,
				'edit_published_citas' => true,
				'delete_published_citas' => true
		    )
		);
		$result2 = add_role(
		    'agente',
		    'Agente',
		    array(
		        'read' => true,
		        'list_users' => true,
		        'edit_users' => true,
		        'edit_citas' => true,
		        'edit_cita' => true,
				'read_cita' => true,
				'publish_citas' => true,
				'delete_cita' => true,
				'delete_citas' => true,
				'edit_published_citas' => true,
				'delete_published_citas' => true,
				'edit_others_citas' => true,
				'delete_others_citas' => true
		    )
		);

		$admins = get_role( 'administrator' );
		$admins->add_cap('edit_cita');
		$admins->add_cap('read_cita');
		$admins->add_cap('delete_cita');
		$admins->add_cap('edit_citas');
		$admins->add_cap('edit_others_citas');
		$admins->add_cap('publish_citas'); 
		$admins->add_cap('read_private_citas');
		$admins->add_cap('edit_citas');
		$admins->add_cap('delete_citas');
		$admins->add_cap('delete_private_citas');
		$admins->add_cap('delete_published_citas');
		$admins->add_cap('delete_others_citas');
		$admins->add_cap('edit_private_citas');
		$admins->add_cap('edit_published_citas');

		$admins->add_cap('edit_actividad');
		$admins->add_cap('read_actividad');
		$admins->add_cap('delete_actividad');
		$admins->add_cap('edit_actividads');
		$admins->add_cap('edit_others_actividads');
		$admins->add_cap('publish_actividads'); 
		$admins->add_cap('read_private_actividads');
		$admins->add_cap('edit_actividads');
		$admins->add_cap('delete_actividads');
		$admins->add_cap('delete_private_actividads');
		$admins->add_cap('delete_published_actividads');
		$admins->add_cap('delete_others_actividads');
		$admins->add_cap('edit_private_actividads');
		$admins->add_cap('edit_published_actividads');

		if ( null !== $result1 ) { /*echo 'Yay! New role created!';*/ }
		else { /*echo 'Oh... the basic_contributor role already exists.';*/ }
		if ( null !== $result2 ) { /*echo 'Yay! New role created!';*/ }
		else { /*echo 'Oh... the basic_contributor role already exists.';*/ }
	}






	function get_theme_logo1(){
		$logo = get_option('custom_theme_logo1');
		$d = get_theme_image($logo);
		return $d;
	}
	
	function get_theme_logo2(){
		$logo = get_option('custom_theme_logo2');
		$d = get_theme_image($logo);
		return $d;
	}
	
	function get_theme_favicon(){
		$favicon = get_option('custom_theme_favicon');
		$d = get_theme_image($favicon);
		return $d;
	}
	
	function get_theme_touch_icon(){
		$touch_icon = get_option('custom_theme_touch_icon');
		$d = get_theme_image($touch_icon);
		return $d;
	}
	
	function get_theme_logos(){
		$d = array();
		$d['logo1'] = get_theme_logo1();
		$d['logo2'] = get_theme_logo2();
		$d['favicon'] = get_theme_favicon();
		$d['touch_icon'] = get_theme_touch_icon();
		$d = (object)$d;
		return $d;
	}
	
	function get_theme_contact(){
		$d = array();
		$d['address'] = get_option('custom_theme_address');
		$d['phone1'] = get_option('custom_theme_phone1');
		$d['phone2'] = get_option('custom_theme_phone2');
		$d['email1'] = get_option('custom_theme_email1');
		$d['email2'] = get_option('custom_theme_email2');
		$d = (object)$d;
		return $d;
	}
	
	function get_theme_social(){
		$d = array();
		$d['facebook'] = get_option('custom_theme_facebook');
		$d['twitter'] = get_option('custom_theme_twitter');
		$d['youtube'] = get_option('custom_theme_youtube');
		$d['instagram'] = get_option('custom_theme_instagram');
		$d['pinterest'] = get_option('custom_theme_pinterest');
		$d = (object)$d;
		return $d;
	}
			
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	add_action( 'widgets_init', 'custom_widgets_init' );
	
	function custom_widgets_init() {
		
		$args_sidebar = array(
			'name' => 'Sidebar',
			'id' => 'sidebar',
			'class' => 'sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-content">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<div class="widget-title"><h3>',
			'after_title'   => '</h3></div>'
		);
		register_sidebar( $args_sidebar );
		
		register_widget( 'JSS_Image_Widget' );
	}
	
	function custom_add_meta_boxes() {
		
		//add_meta_box('posts_gallery_id', 'Galería', 'metabox_posts_gallery_callback', 'post', 'normal', 'low');
		add_meta_box('precio_id', 'Precio', 'metabox_precio_callback', array('paquete', 'precio'), 'normal', 'high');
		add_meta_box('cita_id', 'Datos', 'metabox_cita_callback', array('cita'), 'normal', 'high');
		add_meta_box('actividad_id', 'Datos', 'metabox_actividad_callback', array('actividad'), 'normal', 'high');
		
	}
	
	add_action( 'add_meta_boxes', 'custom_add_meta_boxes' );

	add_action('admin_menu', 'custom_admin_menu');

	function custom_admin_menu() {
		add_submenu_page( 'themes.php', 'Theme Settings', 'Settings', 'administrator', 'theme-settings', 'theme_settiings' );
	}

	function custom_register_settings() {
		//register our settings
		register_setting( 'custom-theme-settings', 'custom_theme_logo1' );
		register_setting( 'custom-theme-settings', 'custom_theme_logo2' );
		register_setting( 'custom-theme-settings', 'custom_theme_favicon' );
		register_setting( 'custom-theme-settings', 'custom_theme_touch_icon' );
		
		register_setting( 'custom-theme-settings', 'custom_theme_address' );
		register_setting( 'custom-theme-settings', 'custom_theme_phone1' );
		register_setting( 'custom-theme-settings', 'custom_theme_phone2' );
		register_setting( 'custom-theme-settings', 'custom_theme_phone3' );
		register_setting( 'custom-theme-settings', 'custom_theme_email1' );
		register_setting( 'custom-theme-settings', 'custom_theme_email2' );
		
		register_setting( 'custom-theme-settings', 'custom_theme_facebook' );
		register_setting( 'custom-theme-settings', 'custom_theme_twitter' );
		register_setting( 'custom-theme-settings', 'custom_theme_youtube' );
		register_setting( 'custom-theme-settings', 'custom_theme_instagram' );
		register_setting( 'custom-theme-settings', 'custom_theme_pinterest' );
	}

	function theme_settiings() {
		include('php/_theme-settings.php');
	}
	
	function init_vars(){
		global $BASE_URL, $TEMPLATE_URL, $IS_THE_HOME, $IS_MOBILE, $JSS_Cart;
		$BASE_URL = get_bloginfo('url');
		$TEMPLATE_URL = get_bloginfo('template_url');
		$IS_THE_HOME = (is_home() || is_front_page());
		$IS_MOBILE = wp_is_mobile();
	}
	
	add_action('wp', 'custom_wp');
	add_action('init', 'custom_init');
	add_action('admin_init', 'custom_admin_init');

	function custom_wp() {
		init_vars();
	}

	function custom_init(){
		//add_post_type_support('post', 'page-attributes');
		add_roles();
		init_vars();
		$session_token = getSessionToken();
		if(!$session_token){
			registerNextToken();
		}
	}
	
	function custom_admin_init(){
		custom_register_settings();
	}
	